## Programs to obtain raw TE candidates
[GenomeTools](http://genometools.org/) is a versatile open-source genome analysis software that includes LTRharvest, an efficient and flexible software tool for *de novo* detection of LTR retrotransposons. `genometools-1.5.10` v1.5.10 was downloaded from [www.genometools.org](http://genometools.org/pub/binary_distributions/).

[LTR_FINDER](https://github.com/xzhub/LTR_Finder) is an efficient program for finding full-length LTR retrotranspsons in genome sequences. `LTR_FINDER_parallel` is an open-source program to run [LTR_FINDER](https://github.com/xzhub/LTR_Finder) in parallel. `LTR_FINDER_parallel` was downloaded from [LTR_FINDER_parallel](https://github.com/oushujun/LTR_FINDER_parallel).

[LTR_retriever](https://github.com/oushujun/LTR_retriever) is a highly accurate and sensitive program for identification of LTR retrotransposons. `LTR_retriever` v2.6 was downloaded from [LTR_retriever](https://github.com/oushujun/LTR_retriever).

[Generic Repeat Finder](https://github.com/bioinfolabmu/GenericRepeatFinder) is a C++ program package for detecting terminal inverted repeats (TIRs), terminal direct repeats (TDRs), interspersed repeats, miniature inverted repeat transposable elements (MITEs), and long terminal repeat (LTR) transposons in genomes.

[TIR-Learner](https://github.com/weijiaweijia/TIR-Learner-Rice) is an open-source ensemble method for TIR transposable element annotation. `TIR-Learner1.19` is a pipeline version converted from [TIR-Learner-Rice](https://github.com/weijiaweijia/TIR-Learner-Rice). The [GenericRepeatFinder](https://github.com/bioinfolabmu/GenericRepeatFinder) is used in TIR-Learner as the search engine.

[HelitronScanner](https://sourceforge.net/projects/helitronscanner/) is a Java program to identify *Helitron* transposons in genome sequences. `HelitronScanner` v1.1 was downloaded from [HelitronScanner](https://sourceforge.net/projects/helitronscanner/).

[TEsorter](https://github.com/zhangrengang/TEsorter) is a program for accurate classification of TEs.

## Citations
	Ellinghaus D, Kurtz S, Willhoeft U. LTRharvest, an efficient and flexible software for de novo detection of LTR retrotransposons. BMC Bioinformatics. 2008;9:18.
	
	Xu Z, Wang H. LTR_FINDER: an efficient tool for the prediction of full-length LTR retrotransposons. Nucleic Acids Res. 2007;35:W265–8.

	Ou S, Jiang N. LTR_FINDER_parallel: parallelization of LTR_FINDER enabling rapid identification of long terminal repeat retrotransposons. Mob DNA 2019;10(1):48.
	
	Ou S, Jiang N. LTR_retriever: A Highly Accurate and Sensitive Program for Identification of Long Terminal Repeat Retrotransposons. Plant Physiol. 2018;176:1410–22.
	
	Su W, Gu X, Peterson T. TIR-Learner, a New Ensemble Method for TIR Transposable Element Annotation, Provides Evidence for Abundant New Transposable Elements in the Maize Genome. Mol Plant. 2019;12:447–60.
	
	Shi J, Liang C. Generic Repeat Finder: A High-Sensitivity Tool for Genome-Wide De Novo Repeat Detection. Plant Physiol. 2019;180(4):1803-1815.

	Xiong W, He L, Lai J, Dooner HK, Du C. HelitronScanner uncovers a large overlooked cache of Helitron transposons in many plant genomes. Proc Natl Acad Sci U S A. 2014;111:10263–8.
	
	Zhang RG, Li GL, Wang XL et. al. TEsorter: an accurate and fast method to classify LTR retrotransposons in plant genomes. Hortic Res, 2022; 9: uhac017
	

